"use strict";


function commentCount(api) {
  var target = document.createElement('script');
  target.src = api;
  document.body.appendChild(target);
}

function jsonpCallback(jsonObj) {
  var count = jsonObj['data'];

  for (var i = 0; i < count.length; i++) {
    if ( 0 === count[i]['comment_count'] ) {
      continue;
    }

    var id = '#' + count[i]['presentation_id'];
    var ele = document.querySelector(id + ' .btn-qa');

    if ( null === ele ) {
      continue;
    }

    var span = document.createElement('span');

    span.classList.add('qa-num');
    span.textContent = count[i]['comment_count'];
    ele.appendChild(span);
  }
}