/* ---------------------------------------
  jquery.floatingmenu.js / ナビ追従機能
  ver.1.2
  last modefied: 2017/04/19
--------------------------------------- */
"use strict";

(function($) {
	$.fn.floatingMenu = function(options) {
		var defaults = {
			media: 'screen and (min-device-width: 768px)',//追従を有効にするメディアクエリ（スマホサイズは無効）
			boxovermenu: '.header', //初期状態のメニュー上部のボックス（ヘッダー）
			boxundermenu: '.footer', //メニューを重ねたくない下のボックス（フッター）
			fixtop: '15px'//メニュー固定時の上マージン
		};
		var settings = $.extend({}, defaults, options);
		var elements = this;
		var timer = null;
		//console.log("floatingMenu呼び出し");
		if ($(elements).length) {
			// 再描画時、bootstrapナビメニューの横幅が小さくなるので調整
			$(window).on('resize scroll', function() {
				$(elements).css('width', 'auto');
				var widthMenu = $(elements).parent().width();
				$(elements).width(widthMenu);
				//console.log("横幅の再取得");
			});

			//指定のメディアクエリかつウィンドウサイズがメニューの縦幅より大きいかつヘッダーより下にスクロールしたときのみメニュー上部固定
			$(window).on('resize scroll', function() {
				clearTimeout( timer );
				timer = setTimeout(function() {
					var headerHight = $(settings.boxovermenu).height();
					var footerHeight = $(settings.boxundermenu).height() + 20;
					var windowHeight = $(window).height();
					var menuHeight = $(elements).height();
					var viewHeight = windowHeight - footerHeight;
					var scrollTop = $(window).scrollTop();
					var fixCond = ((window.matchMedia(settings.media).matches ) && ( viewHeight >= menuHeight ) && ( scrollTop >= headerHight ));
					if ( fixCond ) {
						$(elements).css('position', 'fixed');
						$(elements).css('top', settings.fixtop);
						$(elements).css('left', 'auto');
						$(elements).css('z-index', 100);
						//console.log("メニュー固定");
					} else {
						$(elements).css('position', 'static');
						$(elements).css('top', 'auto');
						$(elements).css('left', 'auto');
						$(elements).css('z-index', 'auto');
						//console.log("メニュー固定解除");
					}
				}, 40 );
			});
		}
		return this;
	};
})(jQuery);
